--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A simple pair of floating-point numbers.
--- @class tes3vector2
--- @operator add(tes3vector2): tes3vector2
--- @operator div(number): tes3vector2
--- @operator mul(tes3vector2): tes3vector2
--- @operator mul(number): tes3vector2
--- @operator sub(tes3vector2): tes3vector2
--- @field x number The first value in the vector.
--- @field y number The second value in the vector.
tes3vector2 = {}

--- Creates a new vector. If no parameters are provided, an empty set will be constructed.
--- @param x? number *Default*: `0`. No description yet available.
--- @param y? number *Default*: `0`. No description yet available.
--- @return tes3vector2 vector No description yet available.
function tes3vector2.new(x, y) end

--- Converts the vector to a string with 2 decimal places.
--- @return string result No description yet available.
function tes3vector2:__tostring() end

--- Creates a copy of the vector.
--- @return tes3vector2 result No description yet available.
function tes3vector2:copy() end

--- Calculates the distance to another vector in the standard way, i.e., using the [Euclidean distance](https://en.wikipedia.org/wiki/Euclidean_distance).
--- @param vec tes3vector2 No description yet available.
--- @return number result No description yet available.
function tes3vector2:distance(vec) end

--- Calculates the distance to another vector, using the [Chebyshev metric](https://en.wikipedia.org/wiki/Chebyshev_distance), which is defined as
--- 
--- 	math.max(math.abs(v1.x - v2.x), math.abs(v1.y - v2.y))
--- 
--- This is useful for ensuring that the x and y coordinates between two vectors are all (independently) within a certain distance from each other.
--- 
--- Here is a geometric description of the difference between the normal distance and the Chebyshev distance for two `tes3vector2`s  `v1` and `v2`:
--- 
--- * If `v1:distance(v2) <= 1`, then `v2` is contained in a circle around `v1` with radius 1 (i.e. diameter 2).
--- * If `v1:distanceChebyshev(v2) <= 1`, then `v2` is contained within a square centered around `v1`, where the square sides have length 2.
--- 
--- @param vec tes3vector2 No description yet available.
--- @return number result No description yet available.
function tes3vector2:distanceChebyshev(vec) end

--- Calculates the distance to another vector, using the [Manhattan (i.e. city block) metric](https://en.wikipedia.org/wiki/Taxicab_geometry). In the two-dimensional case, the Manhattan metric can be thought of as the distance that two taxis will have to travel if they're following a grid system. The formula for the Manhattan distance is
--- 
--- 	math.abs(v1.x - v2.x) + math.abs(v1.y - v2.y) 
--- 
--- This is useful for checking how far you'd actually have to move if you're only allowed to move along one axis at a time.
--- 
--- @param vec tes3vector2 No description yet available.
--- @return number result No description yet available.
function tes3vector2:distanceManhattan(vec) end

--- Calculates the length of the vector.
--- @return number result No description yet available.
function tes3vector2:length() end

--- Returns a vector containing the maximum values for each component of the given vectors.
--- @param other tes3vector2 No description yet available.
--- @return tes3vector2 result No description yet available.
function tes3vector2:max(other) end

--- Returns a vector containing the minimum values for each component of the given vectors.
--- @param other tes3vector2 No description yet available.
--- @return tes3vector2 result No description yet available.
function tes3vector2:min(other) end

--- Normalize the vector in-place, or set its components to zero if normalization is not possible. Returns `true` if the vector was successfully normalized.
--- @return boolean result No description yet available.
function tes3vector2:normalize() end

--- Get a normalized copy of the vector.
--- @return tes3vector2 result No description yet available.
function tes3vector2:normalized() end

